<?php
if ( ! function_exists( 'typecase_layout_video' ) ) {
	function typecase_layout_video( $attrs ) {
			$module = shortcode_atts( array(
			'blockid'               => '',
			'name'               		=> 'vt_lvideo',
			'category'           		=> '',
			'categories'         		=> '',
			'format'             		=> 'video',
			'tags'               		=> '',
			'author'             		=> '',
			'post_not_in'        		=> '',
			'post_in'            		=> '',
			'order'              		=> '',
			'posts_per_page'     		=> '',
			'offset'             		=> '',
			'pagination'         		=> false,
			'vt_hide_cat'        		=> '',
			'vt_hide_author'     		=> '',
			'vt_hide_date'       		=> '',
			'vt_hide_meta'       		=> '',
			'vt_hide_cat'        		=> '',
			'vt_hide_author'     		=> '',
			'vt_hide_date'       		=> '',
			'vt_hide_meta'       		=> '',
		), $attrs );
		$query_data = typecase_query( $module );
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';
		if ( 'yes' === $module['vt_hide_cat'] ) {
			$atts_style[] = 'vt_hide_cat';
		}
		if ( 'yes' === $module['vt_hide_author'] ) {
			$atts_style[] = 'vt_hide_author';
		}
		if ( 'yes' === $module['vt_hide_date'] ) {
			$atts_style[] = 'vt_hide_date';
		}
		if ( 'yes' === $module['vt_hide_meta'] ) {
			$atts_style[] = 'vt_hide_meta';
		}
		$atts_style = implode( ' ', $atts_style );
		?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="vt_clear_at <?php echo esc_attr( $atts_style ); ?>">
			<div id="vt-vid-alist-<?php echo esc_attr( $module['blockid'] ); ?>">
				<div class="vt_vidc_l">
			<?php
			if ( $query_data->have_posts() ) :
				typecase_layout_video_listing( $module, $query_data );
				wp_reset_postdata();
			endif;
			?>
			</div></div></div>
		<?php return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_layout_video_listing' ) ) :
	function typecase_layout_video_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
		?>
				<div class="vt_vidli_w">
				<?php
				$counter = 0;
				$pnum = $query_data->post_count;
				while ( $query_data->have_posts() ) :
				$query_data->the_post();
				if($counter == 0){
					typecase_layout_video_m_listing( $module );
					echo '<div class="vt_vidsb"><div class="vt_vidsb_in">';
					typecase_layout_video_li_listing( $module );
				}else{
					typecase_layout_video_lic_listing( $module );
				}
				if(++$counter === $pnum) {
   					 echo "</div></div>";
  			}
				endwhile;?>
				</div>
			<?php
		endif;
	}
endif;

if ( ! function_exists( 'typecase_layout_video_m_listing' ) ) :
	function typecase_layout_video_m_listing( $module = array(), $query_data = null ) {?>
		<div class="vt_vid_msh">
			<div class="vt_vidfr">
				<span class="vt_vid_sh vt_vid_mp" data-blockid="<?php echo esc_attr( $module['blockid'] ); ?>" data-vidtype="<?php typecase_media_type(get_the_ID());?>" data-<?php typecase_media_type(get_the_ID());?>="<?php typecase_media_url(get_the_ID());?>">
					<span class="vt_vid_mpin">
					<svg fill="currentColor" viewBox="0 0 22 27"><path d="M1 2.242 20.5 13.5 1 24.758V2.242Z" stroke="currentColor"></path></svg>
					</span>
				</span>
			<div class="vt_vid_mc vt_ov_el">
				    <?php if ( has_post_thumbnail()) {?>
				        <div class="vt_img_holder">
					        <div class="vt_imgw vt_radus_e">
					            <div class="vt_imgin"><?php the_post_thumbnail('typecase_medium');?></div>
					            <a class="vt_imgl" href="<?php the_permalink();?>"></a>
					        </div>
				        </div>
				    <?php }?>
				    <div class="vt_fe_text">
				    	<div class="vt_fe_inner">
				    	<?php typecase_post_cat(get_the_ID());?>
				        <h3 class="vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
				        <?php typecase_post_meta(get_the_ID());?>
				        <a href="<?php the_permalink(); ?>" class="vt_cap_ov"></a>
				        </div>
				    </div>
				</div>
		</div>
		</div>
	<?php }
endif;

if ( ! function_exists( 'typecase_layout_video_li_listing' ) ) :
	function typecase_layout_video_li_listing( $module = array(), $query_data = null ) { ?>
		<article class="vt_ac_vid vt_vidsb_c">
			<div class="vt_vidfr">
				<span class="vt_vid_sh vt_vid_tar" data-blockid="<?php echo esc_attr( $module['blockid'] ); ?>" data-vidtype="<?php typecase_media_type(get_the_ID());?>" data-<?php typecase_media_type(get_the_ID());?>="<?php typecase_media_url(get_the_ID());?>"></span>
			</div>
			<div class="vt_cslist_layout vt_lisep">
				<div class="vt_li_in">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin"><?php the_post_thumbnail('typecase_small');?></div>
				        </div>
								<span class="vt_vid_mp">
									<span class="vt_vid_mpin">
									<svg fill="currentColor" viewBox="0 0 22 27"><path d="M1 2.242 20.5 13.5 1 24.758V2.242Z" stroke="currentColor"></path></svg>
									</span>
								</span>
			        </div>
			    <?php }?>
			    <div class="vt_fe_text">
			        <h3 class="vt_fe_title vt_txt_2row"><?php the_title()?></h3>
			        <?php typecase_post_meta(get_the_ID());?>
			    </div>
			</div>
			</div>
		</article>
<?php }
endif;


if ( ! function_exists( 'typecase_layout_video_lic_listing' ) ) :
	function typecase_layout_video_lic_listing( $module = array(), $query_data = null ) { ?>
		<article class="vt_vidsb_c">
			<div class="vt_vidfr">
				<span class="vt_vid_sh vt_vid_tar" data-blockid="<?php echo esc_attr( $module['blockid'] ); ?>" data-vidtype="<?php typecase_media_type(get_the_ID());?>" data-<?php typecase_media_type(get_the_ID());?>="<?php typecase_media_url(get_the_ID());?>"></span>
			</div>
			<div class="vt_cslist_layout vt_lisep">
				<div class="vt_li_in">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="vt_img_holder">
				        <div class="vt_imgw">
				            <div class="vt_imgin"><?php the_post_thumbnail('typecase_small');?></div>
				        </div>
								<span class="vt_vid_mp">
									<span class="vt_vid_mpin">
									<svg fill="currentColor" viewBox="0 0 22 27"><path d="M1 2.242 20.5 13.5 1 24.758V2.242Z" stroke="currentColor"></path></svg>
									</span>
								</span>
			        </div>
			    <?php }?>
			    <div class="vt_fe_text">
			        <h3 class="vt_fe_title vt_txt_2row"><?php the_title()?></h3>
			        <?php typecase_post_meta(get_the_ID());?>
			    </div>
			</div>
			</div>
		</article>
<?php }
endif;