<?php
if ( ! function_exists( 'typecase_menu_layout' ) ) {
	function typecase_menu_layout( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'mega_grid',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '2',
			'offset'             => '',
			'section_title'      => '',
			'section_sub_title'  => '',
			'pagination'         => 'next_prev',
			'g_cols'             => '',
			'posts_cols'         => '',
			'g_style'            => '',
			'show_excep'         => '',
			'tabs_link'       => '',
			'tabs_link_ids'   => '',
			'tabs_link_label' => '',
		), $attrs );

		$module['style_mian']         = 'vt-main-block';
		$module['row_style_mian'] = 'vt-col-row';

		$total_posts = $module['posts_per_page'];
		$query_data = typecase_query( $module );
		$show_excep = $module['show_excep'];
		$module['posts_per_page'] = $total_posts;
		$module['show_excep'] = $show_excep;

		ob_start();

		$atts_style   = array();
		$atts_style[] = 'block-section';
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}

		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="vt_clear_at vt-wp-mu vt_mega_post_<?php echo esc_attr($module['posts_cols']);?> <?php echo esc_attr( $atts_style ); ?>" <?php typecase_get_ajax_attributes( $module, $query_data ); ?>>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'vt-roww vt_contain';
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		}
		?>
		<div class="vt_mega_c_wrap vt_wrap_eb vt_clear_at <?php echo esc_attr( $module['section_style'] ); ?> <?php echo esc_attr( $module['g_cols'] ); ?> <?php echo esc_attr( $module['g_style'] ); ?>">
			<div class="<?php echo esc_attr( $atts_style ); ?>">
			<?php
			switch ( $module['section_style'] ) {
				case 'mega_grid' :
					typecase_menu_g_listing( $module, $query_data );
				break;
				case 'mega_grid_overlay' :
					typecase_ov_listing( $module, $query_data );
				break;
				case 'mega_small_list' :
					typecase_sm_listing( $module, $query_data );
				break;
			}
			echo '</div>';
			typecase_blocknav( $module, $query_data );
			echo '</div></div>';
			wp_reset_postdata();
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'typecase_menu_g_listing' ) ) :
	function typecase_menu_g_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			$counter = 1;
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
				$post_style_mian   = array();
				$post_style_mian[] = 'p-wraper post-' . get_the_ID();
			?>
					<div class="vt_mega_cols">
							<div class="<?php echo join( ' ', $post_style_mian ); ?>">
							  <div class="vt_mega_p_inner vt_mega_gl">
								<?php if ( has_post_thumbnail()) {?>
						          <div class="vt_imgw vt_radus_e">
							          <?php echo typecase_post_type();?>
							          <div class="vt_imgin">
							          	<?php the_post_thumbnail('typecase_layouts');?>
							          </div>
												<?php typecase_video_media(get_the_ID());?>
							          <?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
							          <a class="vt_imgl" href="<?php the_permalink();?>"></a>
									  <?php typecase_post_tumb_cat(get_the_ID());?>
						          </div>
						          <?php }?>
						          <div class="vt_mega_text">
						          		<?php typecase_post_cat(get_the_ID());?>
						          		<h3 class="vt_fr_ptxt vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
						          		<?php typecase_post_meta(get_the_ID());?>
						          </div>
				       			</div>
							</div>
					</div>
			<?php
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'typecase_ov_listing' ) ) :
	function typecase_ov_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
				$post_style_mian   = array();
				$post_style_mian[] = 'p-wraper post-' . get_the_ID();
		?>
					<div class="vt_mega_cols">
							<div class="<?php echo join( ' ', $post_style_mian ); ?>">
							  <div class="vt_mega_p_inner vt_mega_go vt_radus_e">
							  	<?php if ( has_post_thumbnail()) {?>
						          <div class="vt_imgw">
							          <?php echo typecase_post_type();?>
							          <div class="vt_imgin">
							          	<?php the_post_thumbnail('typecase_list');?>
							          </div>
												<?php typecase_video_media(get_the_ID());?>
												<?php typecase_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
												<a class="vt_imgl" href="<?php the_permalink();?>"></a>
						          </div>
						          <?php }?>
						          <div class="vt_mega_text">
								  		<?php typecase_post_ov_cat(get_the_ID());?>
						          		<h3 class="vt_fr_ptxt vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
						          		<?php typecase_post_meta(get_the_ID());?>
						          </div>
				       			</div>
							</div>
					</div>
				<?php
			endwhile;
		endif;
	}
endif;

if ( ! function_exists( 'typecase_sm_listing' ) ) :
	function typecase_sm_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
				$post_style_mian   = array();
				$post_style_mian[] = 'p-wraper post-' . get_the_ID();
		?>
					<div class="vt_mega_cols">
							<div class="<?php echo join( ' ', $post_style_mian ); ?>">
							  <div class="vt_mega_p_inner vt_mega_sml">
								<?php if ( has_post_thumbnail()) {?>
						          <div class="vt_imgw vt_radus_e">
							          <?php echo typecase_post_type();?>
							          <div class="vt_imgin">
							          	<?php the_post_thumbnail('typecase_small');?>
							          </div>
							          <a class="vt_imgl" href="<?php the_permalink();?>"></a>
						          </div>
						          <?php }?>
						          <div class="vt_mega_text">
								  		<h3 class="vt_fr_ptxt vt_fe_title vt_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
						          		<?php typecase_post_meta_date(get_the_ID());?>
						          </div>
				       			</div>
							</div>
					</div>
				<?php
			endwhile;
		endif;
	}
endif;
