(function ($) {
    "use strict";
    var $window, $document, $body;
    var vtCookies = {
        setCookie: function setCookie(key, value, time, path) {
            var expires = new Date();
            expires.setTime(expires.getTime() + time);
            var pathValue = '';
            if (typeof path !== 'undefined') {
                pathValue = 'path=' + path + ';';
            }
            document.cookie = key + '=' + value + ';' + pathValue + 'expires=' + expires.toUTCString();
        },
        getCookie: function getCookie(key) {
            var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');
            return keyValue ? keyValue[2] : null;
        }
    };
    $window         = $(window);
    $document       = $(document);
    $body           = $("body");
    var Optloadfnc  = {
        initialised: false,
        init: function() {
            if (!this.initialised) {
                this.initialised = true;
            } else {
                return;
            }
            this.vtmenucalc();
            this.vt_img_pop();
            this.vt_vid_pop();
            this.vt_img_slider();
            this.vt_nav_detect();
            this.vt_nav_custom();
            this.vt_gdpr();
            this.vt_to_top();
            this.vt_qnt_num();
            this.vt_dn_tog();
            this.vt_lazy_opt();
            this.vt_n_mode_opt();
            this.vt_n_mode_store();
            this.livmode();
            this.vt_sh_link();
            this.vt_rd_scroll();
    },    
    vt_img_pop: function() {
        var pop_img_wrap = $('.vt_gal_img');
        var pop_magnific_popup = pop_img_wrap.data("mfp-src");
        if (undefined !== pop_magnific_popup) {
            pop_img_wrap.magnificPopup({
            type: "image",
            mainClass: "vt-fade-pop",
            removalDelay: 350,
            gallery: {
            enabled: true,
            arrowMarkup: '<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%">' + vtParamsOpt.pop_nav_b + "</button>"
            },
            closeMarkup: '<button title="%title%" type="button" class="mfp-close">' + vtParamsOpt.pop_close_b + "</button>"
            });
        }
    },
    vt_vid_pop: function() {
      $('.vt_pop_vid').magnificPopup({
          type: 'iframe',
          mainClass: 'vt-fade-pop',
          removalDelay: 350,
          preloader: false,
          fixedContentPos: true,
          closeMarkup: '<button title="%title%" type="button" class="mfp-close">' + vtParamsOpt.pop_close_b + "</button>"
      });
    },
    vt_img_slider: function() {
        var i;
        var swiperContainer = $('.vt-pgal-slider');
            for (i = 0; i < swiperContainer.length; i++) {
            var slider = $(swiperContainer[i]);
            var navid = '.vtc-navigation-'+slider.data("swpid"),
                pagiid = '.vtc-pagination-'+slider.data("swpid");
            
            var navigation = {
                nextEl: navid+' .vt-swiper-button-next',
                prevEl: navid+' .vt-swiper-button-prev',
            };            
            var pagination =  {
                el: pagiid+' .swiper-pagination',
                type: 'bullets',
                clickable: true,
            };
            var swiper = new Swiper( slider, {
                loop: true,
                autoplay: true,
                simulateTouch: true,
                parallax: true,
                speed: 500,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false
                },
                navigation: navigation,
                pagination: pagination,
            });
            }
    },
    vt_nav_detect: function() {
        var $menuItems = $('.navigation_wrapper .vt_main_menu > li.menu-item-has-children');
        if ($menuItems.length) {
            $menuItems.each(function (i) {
                var thisItem = $(this),
                menuItemPosition = thisItem.offset().left,
                dropdownMenuItem = thisItem.find(' > ul'),
                dropdownMenuWidth = dropdownMenuItem.outerWidth(),
                menuItemFromLeft = $(window).width() - menuItemPosition;
                var dropDownMenuFromLeft;
                    if (thisItem.find('li.menu-item-has-children').length > 0) {
                        dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
                    }
                dropdownMenuItem.removeClass('vtc-right-menu');
                    if (menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth) {
                        dropdownMenuItem.addClass('vtc-right-menu');
                    }
            });
        }
    },    
    vt_nav_custom: function() {
            $('.menu_mobile_icons, .mobile_menu_overlay').on("click", function() {
            $('#vt_sb_nav').toggleClass('vt_mobile_nav_open');
            $('.mobile_menu_overlay').toggleClass('mobile_menu_active');
            $('.mobile_nav_class').toggleClass('active_mobile_nav_class');
            });

            $('.widget_nav_menu ul > li.menu-item-has-children').on( 'click', function(){
                    var parentMenu = jQuery(this);
                    parentMenu.toggleClass('active');
                    return false;
                });

            $("#mobile_menu_slide .menu-item-has-children > a").append($("<span/>", {
                class: 'arrow_down'
            }).html('<i class="vti-down-chevron-1" aria-hidden="true"></i>'));
            $('#mobile_menu_slide .arrow_down i').on("click", function() {
                var submenu = $(this).closest('.menu-item-has-children').find(' > .sub-menu');
                $(this).toggleClass("vti-down-chevron-1").toggleClass("vti-up-chevron-1");
                $(submenu).slideToggle(150,"linear");
                return false;
            });
            $('.search_form_menu_personal_click').on("click", function() {
                $('.search_form_menu_personal').toggleClass('search_form_menu_personal_active');
                $('.mobile_nav_class').toggleClass('active_search_box');
                setTimeout(function() {
                    $('.search_form_menu_personal').find('.search_btn').focus()
                }, 100)

            });

            $(document).keyup(function(e) {
                if (e.keyCode == 27) {
                    $('.search_form_menu_personal.search_form_menu_personal_active').toggleClass('search_form_menu_personal_active');
                    $('.mobile_nav_class.active_search_box').toggleClass('active_search_box');
                }
            });

            $('.search_form_menu_click').on('click', function(e) {
                e.preventDefault();
                $('.search_form_menu').toggle();
                $(this).toggleClass('active');
            });
            if ($('.sb-toggle-left').length) {
                $('.sb-toggle-left').on("click", function() {
                    $('#nav-wrapper').toggle(100);
                });
                $("#menu-main-menu .menu-item-has-children > a").append($("<span/>", {
                    class: 'arrow_down'
                }).html('<i class="vti-down-chevron-1"></i>'));
            }

            $('#nav-wrapper .menu .arrow_down').on("click", function() {
                var $submenu = $(this).closest('.menu-item-has-children').find(' > .sub-menu');

                if ($submenu.hasClass('menu-active-class')) {
                    $submenu.removeClass('menu-active-class');
                } else {
                    $submenu.addClass('menu-active-class');
                }
                return false;
            });

            if ($('body').hasClass('vt_nav_stick')) {
                var theElement = $('body').hasClass('vt_nav_active') ? $('.vt_cus_sihead') : $('.tp_head_on');
                var vt_navbase, $orgElement, $vt_r_menudElement, orgElementTop, currentScroll, previousScroll = 0, scrollDifference, detachPoint = 320, hideShowOffset = 2,
                $html = $('body');
                $orgElement = $('.vt_base_menu');
                if ($orgElement.length) {
                $vt_r_menudElement = $('.vt_r_menu');
                vt_navbase = $('body').hasClass('vt_nav_slide');
                $vt_r_menudElement.width($orgElement.width());
                $(window).on("resize", function() {
                    $vt_r_menudElement.width($orgElement.width());
                });
                $(window).on("scroll", function() {
                    if (jQuery(this).scrollTop() > 500) {
                        jQuery("#go-top").fadeIn();
                    } else {
                        jQuery("#go-top").fadeOut();
                    }
                    currentScroll = $(this).scrollTop(),
                    scrollDifference = Math.abs(currentScroll - previousScroll);

                    if ($(this).scrollTop() <= 330) {
                        if (!$html.hasClass('menu-hide-fixed')) {
                        $html.addClass('menu-hide-fixed');
                        }
                    }else{
                        $html.removeClass('menu-hide-fixed');
                    }
                    
                    $vt_r_menudElement.width($orgElement.width());
                        orgElementTop = $orgElement.offset().top;
                        if (currentScroll >= (orgElementTop) && currentScroll != 0) {
                            if (vt_navbase) {
                                if (currentScroll > detachPoint) {
                                    if (!$html.hasClass('menu-detached')) {
                                        $html.addClass('menu-detached');
                                    }                                    
                                    
                                }
                                if (scrollDifference >= hideShowOffset) {
                                    if (currentScroll > previousScroll) {
                                        if (!$html.hasClass('menu-invisible')) {
                                            $html.addClass('menu-invisible');
                                        }
                                    } else {
                                        if ($html.hasClass('menu-invisible')) {
                                            $html.removeClass('menu-invisible');
                                        }
                                    }
                                }
                            } else {
                                $vt_r_menudElement.addClass('m-visible');
                                $orgElement.addClass('m-hidden');
                            }
                        } else {
                            $vt_r_menudElement.removeClass('m-visible');
                            $orgElement.removeClass('m-hidden');

                            if (vt_navbase) {
                                $html.removeClass('menu-detached').removeClass('menu-invisible');
                            }
                        }
                        previousScroll = currentScroll;
                });
            }
            }
            },
            vtmenucalc: function() {
                var vtCusMenu = $('.vt_hwrap');
                if (vtCusMenu.length > 0) {
                vtCusMenu.each(function () {
                    var thisItem = $(this);
                    thisItem.find('.vt-cus-mega-menu').css({
                    'width': $(window).width(),
                    'left': -thisItem.offset().left,
                    });
                    thisItem.addClass('mega-menu-loaded')
                })
                }
            },
            vt_gdpr: function() {
                    if ($('#vt-gdpr').length > 0) {
                        if ($.cookie('vt_cookie_accept') !== '1') {
                            $('#vt-gdpr').css('display', 'block');
                            setTimeout(function () {
                                $('#vt-gdpr').addClass('vt-display');
                            }, 10)
                        }
                        $('#vt-gdpr-accept').off('click').on('click', function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            $.cookie('vt_cookie_accept', '1', {expires: 30, path: '/'});
                            $('#vt-gdpr').removeClass('vt-display');
                            setTimeout(function () {
                                $('#vt-gdpr').css('display', 'none');
                            }, 500)
                        })
                    }
            },
            vt_to_top: function() {
                    $("#go-top").on("click", function() {
                    jQuery("body,html").animate({
                        scrollTop: 0
                    }, 800);
                    return false;
                    });
            },
            vt_qnt_num: function() {
                $('.quantity .vtb-btn').on("click", function(e) {
                e.preventDefault();
                var woo_btn = $(this);
                var step = 1;
                var input = woo_btn.parent().find('input');
                var min = 1;
                var max = 99999;
                var input_old_val = parseInt(input.val());
                var input_new_val = parseInt(input.val());
                if (input.attr('step')) {
                    step = parseInt(input.attr('step'));
                }
                if (input.attr('min')) {
                    min = parseInt(input.attr('min'));
                }
                if (input.attr('max')) {
                    max = parseInt(input.attr('max'));
                }
                if (woo_btn.hasClass('up')) {
                    if (input_old_val < max) {
                        input_new_val = input_old_val + step;
                    } else {
                        input_new_val = 1;
                    }
                } else if (woo_btn.hasClass('down')) {
                    if (input_old_val > min) {
                        input_new_val = input_old_val - step;
                    } else {
                        input_new_val = 0;
                    }
                }
                if (!input.attr('disabled')) {
                    input.val(input_new_val).change();
                }
            });
            },
            vt_ma_effect_load: function(vt_post_effect) {
                var $commonElements = $('.vt_ani_col');
                if ($commonElements.length) {
                    $commonElements.each(function () {
                        var $thisItem = $(this);
                        if (vt_post_effect) {
                            $thisItem.addClass('vt_ma_nitem');
                            setTimeout(function () {
                                $thisItem.addClass('vt_ma_appear');
                            }, 1100);
                        } else {
                            $thisItem.waypoint( function () {
                                $thisItem.addClass('vt_ma_appear');
                            }, {
                                offset: '105%'
                            } );
                        }
                    });
                }
            },
            vt_rd_scroll: function() {
                $(window).on("scroll", function() {            
                    var target = $('.vt_sp_con');
                    if ( target.length > 0 ) {
                    target.each(function (id, el) {
                        var _el = $(el),
                            pageTop = $(window).scrollTop(),
                            pageBottom = pageTop + $(window).height(),
                            elementTop = _el.offset().top,
                            elementBottom = elementTop + _el.height(),
                            elementBottomNew = elementTop + 0,
                            key = _el.attr('id');
                                        
                            if (pageTop >= elementTop && pageTop <= elementBottom) {
                              var elementHeight = _el.height();
                              var totalScroll = -(elementTop - pageTop) / elementHeight * 125;
                            $('.vt_rd_read[data-key = ' + key + ']').css({'width': totalScroll + '%', 'opacity': '1'});
                            }
                            if (pageTop < elementTop) {
                              $('.vt_rd_read[data-key = ' + key + ']').css({'width': '0', 'opacity': '0'});
                            }
                            if (pageTop > elementBottom) {
                              $('.vt_rd_read[data-key = ' + key + ']').css({'width': '100%', 'opacity': '0'});
                            }
                      });                        
                    }
                });                
            },
            vt_dn_tog: function() {
                $('.typecase_day_night .vt_moon').on("click", function() {
                    $('.typecase_day_night').addClass('vt_night_en');
                    $('.typecase_day_night').removeClass('vt_day_en');
                    $('.vt_en_day_night').addClass('options_dark_skin');
                    $('.mobile_nav_class').addClass('wp-night-mode-on');
                    $.cookie('vtendnight', 'no', {
                        expires: 7,
                        path: '/'
                    });
                    $.cookie('vtenday', 'no', {
                        expires: 7,
                        path: '/'
                    });
                });
                $('.typecase_day_night .vt_sun').on("click", function() {
                    $('.typecase_day_night').addClass('vt_day_en');
                    $('.typecase_day_night').removeClass('vt_night_en');
                    $('.vt_en_day_night').removeClass('options_dark_skin');
                    $('.mobile_nav_class').removeClass('wp-night-mode-on');

                    $.cookie('vtenday', 'no', {
                        expires: 7,
                        path: '/'
                    });
                    $.cookie('vtendnight', 'no', {
                        expires: 7,
                        path: '/'
                    });

                });
            },
            vt_lazy_opt: function() {
                window.lazySizesConfig = window.lazySizesConfig || {};
                window.lazySizesConfig.expand = 1000;
                window.lazySizesConfig.loadMode = 1;
                window.lazySizesConfig.loadHidden = false;
            },
            vt_n_mode_opt: function() {
                var nightModeButton = document.querySelectorAll('.vt-night-toggle-icon');
                for (var i = 0; i < nightModeButton.length; i++) {
                    nightModeButton.item(i).onclick = function (event) {
                        event.preventDefault();
                        for (var i = 0; i < nightModeButton.length; i++) {
                            nightModeButton[i].classList.toggle('active');
                        }
                        if (this.classList.contains('active')) {
                            vtCookies.setCookie('vtmode_dn', 'true', 2628000000, '/');
                        } else {
                            vtCookies.setCookie('vtmode_dn', 'false', 2628000000, '/');
                        }
                    };
                }
            },
            vt_n_mode_store: function() {
                var nightModeButton = document.querySelectorAll('.vt-night-toggle-icon');
                if ('true' === vtCookies.getCookie('vtmode_dn')) {
                     document.body.classList.add('wp-night-mode-on');
                     $('.vt_en_day_night').addClass('options_dark_skin');
                     $('.typecase_day_night').addClass('vt_night_en');
                     $('.typecase_day_night').removeClass('vt_day_en');
                     for (var i = 0; i < nightModeButton.length; i++) {
                         nightModeButton[i].classList.add('active');
                     }
                 }else if ('false' === vtCookies.getCookie('vtmode_dn')) {
                         document.body.classList.remove('wp-night-mode-on');
                         $('.vt_en_day_night').removeClass('options_dark_skin');
                         $('.typecase_day_night').removeClass('vt_night_en');
                         for (var i = 0; i < nightModeButton.length; i++) {
                             nightModeButton[i].classList.remove('active');
                         }
                 }else{
                   if (vtParamsOpt.opt_dark == 1) {
                         document.body.classList.add('wp-night-mode-on');
                         $('.vt_en_day_night').addClass('options_dark_skin');
                         $('.typecase_day_night').addClass('vt_night_en');
                         $('.typecase_day_night').removeClass('vt_day_en');
                         for (var i = 0; i < nightModeButton.length; i++) {
                             nightModeButton[i].classList.add('active');
                         }
                     }
                 }
            },
            mediaFrameLoad: function() {
                var vtFrame = document.getElementsByClassName( 'vt_fm_vid_load' ),
                    vtOptFrame = new IntersectionObserver(function (entries) {
                    entries.forEach(function (entry ) {
                        if ( entry.isIntersecting ) {
                            vtOptFrame.unobserve(entry.target);
                            Optloadfnc.mediaFrameCheck(entry.target);
                        }
                    });
                }, { threshold: [0], rootMargin: '150px 0px', });
                for ( var i = vtFrame.length - 1; i >= 0; i-- ) {
                    if ( ! vtFrame[i].classList.contains( 'vt_fm_loading' ) ) {
                        vtOptFrame.observe( vtFrame[i] );
                    }
                }
            },
            mediaFrameCheck: function( iframe ) {
                var src = iframe.getAttribute('data-lazy-src');                                
                iframe.setAttribute('src', src );
                $(iframe).on( 'load', function() {
                    var commonElements = $('.vt_img_holder');
                    var vt_vidfr_in = commonElements.find( '.video-wrap' );
                    iframe.classList.add('vt_fm_loading');
                    iframe.classList.add( 'loaded' );
                    $(this).parent().addClass('vt_load_vids');                    
                });
            },
            vt_wp_mu: function(i) {
                var commonElements = $('.vt-wp-mu');
                if (commonElements.length){
                    for (i = 0; i < commonElements.length; i++) {
                    var $commonElements = $(commonElements[i]);
                        let $optElements = $commonElements.find( '.vt_mega_cols' );
                        $optElements.each(
                            function (index) {
                                let $character = $( this ), transitionDelay = (index * 100) + 'ms';
                                $character.css({'animation-delay': transitionDelay});
                            }
                        );
                    }
                }
            },
            vt_sh_link: function() {
                var vtMainShare = $('.vt_shli .vt_sshl');
                if ( vtMainShare.length > 0 ) {            
                    vtMainShare.on('click', function() {
                        var left = (screen.width/2)-(640/2),
                                top = (screen.height/2)-(440/2)-100;
                        window.open($(this).attr('href'), 'mywin', 'left='+left+',top='+top+',width=640,height=440,toolbar=0');
                        return false;
                    });
                }
            },
            livmode: function() {
              var $body = $( 'body' );
                    $body.on( 'click', '.vt_vid_sh', Optloadfnc.mdsOpt );
                },
            mdsOpt: function( ) {
              var video = document.createElement( 'video' );
              var thisItem  = $( this ),
                        optVid  = thisItem.data(),
                        vidDisplay;
                        if ( optVid.vidtype == 'embedvid' ) {
                            if ( optVid.embedvid === '' ) {
                                vidDisplay = '';
                            } else {
                                vidDisplay = '<iframe title="Video" frameborder="0" seamless="seamless" allow="autoplay" src="' + optVid.embedvid + '" allowfullscreen></iframe>';
                            }
                        } else {
                                if ( video.canPlayType( 'video/mp4;' ) ) { video.type= 'video/mp4'; if ( optVid.localvid !== '' ) { video.src = optVid.localvid; } }
                                video.setAttribute( 'controls', 'controls' );
                                video.setAttribute( 'controlsList', 'nodownload' );
                                video.play();
                                vidDisplay = video;
                        }
                        var vt_vidli_w = thisItem.closest( '.vt_vidsb_c' );
                        if ( vt_vidli_w.hasClass( 'vt_ac_vid' ) ) { return; }
                        var vt_vidli_in = $( '#vt-vid-alist-' + optVid.blockid );
                        var vt_vidli_fr = vt_vidli_in.find( '.vt_vid_msh' );
                        var vt_vidfr_in = vt_vidli_fr.find( '.vt_vidfr' );
                        vt_vidli_fr.addClass( 'vt_vidprog' ).removeClass( 'vt_vidacsh' );
                        vt_vidfr_in.html( '<div class="vt_vid_pac"><div id="vt-vid-ac-' + optVid.blockid + '" class="vt_vid_pin"></div></div>' );
                        $( '#vt-vid-ac-' + optVid.blockid ).append(vidDisplay );
                        setTimeout( function() { vt_vidli_fr.addClass( 'vt_vidacsh vt_vidfr' ); }, 190 );
                        if ( thisItem.hasClass( 'vt_vid_tar' ) ) { vt_vidli_w.addClass( 'vt_ac_vid' ).siblings().removeClass( 'vt_ac_vid' ); }
                    return false;
                }
    };
    $(document).ready(function(){
        Optloadfnc.init();
        cusMainScript.init();
    });
    $(window).on('load',function(){
        Optloadfnc.vt_ma_effect_load();
        Optloadfnc.vt_wp_mu();
        Optloadfnc.mediaFrameLoad();
    });
    window.addEventListener('resize',function(){
        Optloadfnc.vtmenucalc();
        Optloadfnc.vt_nav_detect();
    });
    })(jQuery);
vtSpscript = (function($) {
        var vtMainOpt = { vtSpLoad: function() { this.vtGalPop(); this.vtShLink(); this.JlLoadV(); },
        JlLoadV: function() {
            var vtFrame = document.getElementsByClassName( 'vt_fm_vid_load' ),
                vtOptFrame = new IntersectionObserver(function (entries) {
                entries.forEach(function (entry ) {
                    if ( entry.isIntersecting ) {
                        vtOptFrame.unobserve(entry.target);                        
                        var iframe = entry.target;
                        var src = iframe.getAttribute('data-lazy-src');                                
                        iframe.setAttribute('src', src );
                        $(iframe).on( 'load', function() {
                            var commonElements = $('.vt_img_holder');
                            var vt_vidfr_in = commonElements.find( '.video-wrap' );
                            iframe.classList.add('vt_fm_loading');
                            iframe.classList.add( 'loaded' );
                            $(this).parent().addClass('vt_load_vids');                    
                        });
                    }
                });
            }, { threshold: [0], rootMargin: '150px 0px', });
            for ( var i = vtFrame.length - 1; i >= 0; i-- ) {
                if ( ! vtFrame[i].classList.contains( 'vt_fm_loading' ) ) {
                    vtOptFrame.observe( vtFrame[i] );
                }
            }
        },        
        vtShLink: function() {
            var vtMainShare = $('.vt_shli .vt_sshl');
            if ( vtMainShare.length > 0 ) {            
                vtMainShare.on('click', function() {
                    var left = (screen.width/2)-(640/2),
                            top = (screen.height/2)-(440/2)-100;
                    window.open($(this).attr('href'), 'mywin', 'left='+left+',top='+top+',width=640,height=440,toolbar=0');
                    return false;
                });
            }
        },        
        vtGalPop: function() {
            var pop_img_wrap = $('.vt_gal_img');
            var pop_magnific_popup = pop_img_wrap.data("mfp-src");
            if (undefined !== pop_magnific_popup) {
                pop_img_wrap.magnificPopup({
                type: "image",
                mainClass: "vt-fade-pop",
                removalDelay: 350,
                gallery: {
                enabled: true,
                arrowMarkup: '<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%">' + vtParamsOpt.pop_nav_b + "</button>"
                },
                closeMarkup: '<button title="%title%" type="button" class="mfp-close">' + vtParamsOpt.pop_close_b + "</button>"
                });
            }
        },
    }
    return vtMainOpt;
    })(jQuery);        
    (function () {
        const detectScrlDown = 0.76; let numPDisplay = []; let spSelect_load; let spLoadView; let spProgress = false; let spLoadItems = []; let spEachItem;
        function spLoadScript() { spMainLoad(spScript); }
        function spScript() {
            if (typeof JlOptPosts === 'undefined' || !window.fetch) { return; }
            numPDisplay = JlOptPosts;
            spEachItem = document.querySelector('.vt_sp_con');
            spSelect_load = spEachItem;		
            spLoadItems.push(spSelect_load);
            if (!spSelect_load) { return; }
            Object.assign(spSelect_load.dataset, { title: document.title, url: window.location.href });
            document.addEventListener('scroll', () => {
                if (spProgress || spEachItem.dataset.loading) { return; }
                let triggerLoad = spEachItem.offsetTop + (spEachItem.offsetHeight * detectScrlDown);
                if (window.scrollY > triggerLoad) { spProgress = true; requestAnimationFrame(spDisplayItems); }
            });
            spLoadView = new IntersectionObserver(spActivePost, { root: null, rootMargin: '0px 0px -50%', threshold: 0 });
        }        
        function spSpinView(target) {
            target = target || spEachItem;
            const spin = document.createElement('div');
            Object.assign(spin, { className: 'vt_sp_spin' });
            target.after(spin);
        }
        function spDisplayItems() {
            const spItems = numPDisplay.shift();
            if (!spItems) { return; }
            if (spSelect_load === spEachItem) { spSelect_load.classList.add('vt_spm_con'); }
            const addPostContainer = (html) => {
                if (!html) { return; }
                const spParam = new DOMParser();
                const spConType = spParam.parseFromString(html, 'text/html');			
                const spOutput = spConType.querySelector('.vt_sp_con');
                if (!spOutput) { return; }
                const spWrapper = document.createElement('div');
                spEachItem.after(spWrapper);
                Object.assign(spWrapper.dataset, { url: spItems.url, title: spItems.title, });
                Object.assign(spWrapper, { className: 'vt_sp_lp', innerHTML: spOutput.outerHTML });
                spEachItem = spWrapper;
                spLoadItems.push(spWrapper);
                return spWrapper;
            };
            spSpinView();
            fetch(spItems.url).then(resp => resp.text()).then(html => {
                    const spWrapper = addPostContainer(html);
                    document.querySelectorAll('.vt_sp_spin').forEach(e => e.remove());	
                    if (!spWrapper) { return; }
                    spsLoads(spWrapper);
                    if (window.twttr && twttr.widgets && twttr.widgets.load) { twttr.widgets.load(); }
                    requestAnimationFrame(() => {
                        spProgress = false;
                        spCheckLoad(spWrapper);
                        spLoadView.observe(spWrapper);
                        vtSpscript.vtSpLoad(spWrapper);
                    });                    
                });
        } 
        function spActivePost(entries) {
            let spMainPost;
            let spActiveItem;
            for (let element of entries) {
                if (element.intersectionRatio <= 0) { spActiveItem = element.target; continue; }		
                spMainPost = element.target;
                break;
            }
            if (!spMainPost) {
                const spFirstPost = spLoadItems.findIndex(spItems => spItems === spActiveItem);
                const spMovePost = spLoadItems[spFirstPost - 1];
                if (spMovePost && spMovePost.getBoundingClientRect().bottom >= 0) { spMainPost = spMovePost; }
            }
            if (spMainPost && spMainPost.dataset.url) {
                window.history.pushState(null, spMainPost.dataset.title, spMainPost.dataset.url);
                document.title = spMainPost.dataset.title;
                spActiveView();
            }
        }   
        function spActiveView() {
            if (!spEachItem || spEachItem.dataset.viewTracked) { return; }
            if (window.gtag) { window.gtag('event', 'page_view', { page_title: spEachItem.dataset.title, page_location: spEachItem.dataset.url }); }
            if (window.ga) { window.ga('send', 'pageview', spEachItem.dataset.url); }
            spEachItem.dataset.viewTracked = 1;
        }
        function spsLoads(element) {
            element.querySelectorAll('script').forEach(item => {
                const scrawl = document.createElement('script');
                scrawl.text = item.textContent;
                const attrs = item.attributes;
                for (const attr of attrs) { scrawl.setAttribute(attr.name, attr.value || true); }
                if (scrawl.type && scrawl.type === 'rocketlazyloadscript') { scrawl.type = 'text/javascript'; }
                if (!scrawl.src && scrawl.dataset.src) { scrawl.src = scrawl.dataset.src; }		
                document.body.append(scrawl);
            });
        }
        function spCheckLoad(spEachItem) {
            const spConType = document.documentElement;
            if (spConType.scrollHeight - spConType.scrollTop <= spConType.clientHeight + 75) { spEachItem.scrollIntoView(); }
        }    
        function spMainLoad(optsc) { document.readyState !== 'loading' ? optsc() : document.addEventListener('DOMContentLoaded', optsc); }
        spLoadScript();
    })();
    var cusMainScript = (function (OptScript, $) { OptScript.$body = $('body'); OptScript.$document = $(document); OptScript.$html = $('html, body'); OptScript.$window = $(window); OptScript.$ajax = {}; OptScript.svtoad = {};
    OptScript.init = function () { this.queryList(); this.cusLoadScript();};
    OptScript.cusLoadScript = function () { this.vt_menu_cat(); this.navNextPre(); this.navloadMore(); this.navautoload(); this.blocknest();};
    OptScript.loadpFunctions = function () {this.$html.off();this.$document.off();this.$window.trigger('load');this.cusLoadScript();};
    OptScript.$blocksave = {data: {},get: function (id) {return this.data[id];},set: function (id, data) {this.remove(id);this.data[id] = data;},remove: function (id) {delete this.data[id];},exist: function (id) {return this.data.hasOwnProperty(id) && this.data[id] !== null;}};
    OptScript.blocknest = function () {
        var wrapper = $('.vt_ma_grid.vt_load_magrid');
        if (wrapper.length > 0) {
            wrapper.each(function () {
                var jcontain = $(this).find('.vt_contain').eq(0);
                $(jcontain).isotope({itemSelector: '.vt_ma_grid_col', percentPosition: true,masonry: {columnWidth: '.vt_ma_grid_w', gutter: '.vt_ma_grid_gutter'}});
                jcontain.imagesLoaded().progress(function () {$(jcontain).isotope('layout');});
            });
        }
    };
    OptScript.blockDatalist = function (block) {
        return {blockid: block.data('blockid'), section_style: block.data('section_style'), post_type: block.data('post_type'), post_type_tax: block.data('post_type_tax'),term_slugs: block.data('term_slugs'), posts_per_page: block.data('posts_per_page'), page_max: block.data('page_max'), page_current: block.data('page_current'), category: block.data('category'), categories: block.data('categories'), orderby: block.data('orderby'), author: block.data('author'), tags: block.data('tags'), tabs_link: block.data('tabs_link'), post_not_in: block.data('post_not_in'), format: block.data('format'), offset: block.data('offset')};
    };
    OptScript.trackPagenav = function (block) {
        var settings = this.blockDatalist(block); var max_offsets = settings.page_max+settings.offset;
        var settings_max = ((settings.page_max * settings.posts_per_page) - settings.offset) / settings.posts_per_page;
        if(settings.page_current >= max_offsets || settings.page_current >= settings.page_max || settings.page_max <= 1 || settings.page_current >= settings_max) {
            block.find('.vt-load-link').hide(); block.find('.vt-load-animation').hide(); block.find('.vt_el_nav_w').addClass('vt_hide_pagination'); block.find('.vt_lmore_c').addClass('vt_hide_pagination'); block.find('.vt_autoload').addClass('vt_hide_pagination');
        }else{
            block.find('.vt-load-link').show(); block.find('.vt-load-link').css('opacity', 1); block.find('.vt-load-animation').hide(); block.find('.vt_el_nav_w').removeClass('vt_hide_pagination'); block.find('.vt_lmore_c').removeClass('vt_hide_pagination'); block.find('.vt_autoload').removeClass('vt_hide_pagination');
        }
        if (settings.page_max < 2) { block.find('.vt-foot-nav').addClass('vt_disable'); }
        if (settings.page_current >= settings.page_max) { block.find('.vt-next-nav').addClass('vt_disable'); }
        if (settings.page_current <= 1) { block.find('.vt-prev-nav').addClass('vt_disable'); }
    };
    OptScript.queryList = function () {
        var object = this;
        $('.vt-tab-link').off('click').on('click', function (e) {
            e.preventDefault(); e.stopPropagation(); var link = $(this); var block = link.parents('.block-section'); var blockid = block.attr('id');
            if (true == object.$ajax[blockid + '_loading']) { return; }
            object.$ajax[blockid + '_loading'] = true;
            var filterVal = link.data('ajax_filter_val');
            block.find('.vt-tab-link').removeClass('vt-ac-m');
            block.find('.vt-tab-link').not(this).addClass('vt-rm-ac');
            link.addClass('vt-ac-m');
            object.startEffect(block, 'replace');
            var settings = object.blockDatalist(block);
            object.resetQuickFilter(block, settings, filterVal);
            setTimeout(function () { object.blockLink(block, settings); }, 400);
        });
        OptScript.navNextPre = function () {
            var object = this;
            $('.vt-foot-nav').off('click').on('click', function (e) {
                e.preventDefault(); e.stopPropagation(); var link = $(this); var block = link.parents('.block-section'); var blockid = block.attr('id');
                if (true == object.$ajax[blockid + '_loading']) { return; }
                object.$ajax[blockid + '_loading'] = true;
                var type = link.data('type'); var settings = object.blockDatalist(block);
                object.startEffect(block, 'replace');
                object.navNextPreProcess(block, settings, type);
            });
        };
        OptScript.navNextPreProcess = function (block, settings, type) {
            if ('prev' == type){ settings.page_next = parseInt(settings.page_current) - 1; }else{ settings.page_next = parseInt(settings.page_current) + 1; }
            var cacheSettings = settings; delete cacheSettings.page_max; cacheSettings.page_current = settings.page_next; var cacheID = JSON.stringify(cacheSettings);
            if (object.$blocksave.exist(cacheID)) {
                var data = object.$blocksave.get(cacheID);
                if ('undefined' != typeof data.page_current) { block.data('page_current', data.page_current); }
                object.endEffect(block, data.content, 'replace');
                return false;
            } else {
                $.ajax({
                    type: 'POST', url: vtParamsOpt.ajaxurl, data: { action: 'typecase_loadnavs', data: settings },
                    success: function (data) {
                        data = $.parseJSON(JSON.stringify(data));
                        if ('undefined' != typeof data.page_current) { block.data('page_current', data.page_current); }
                        object.$blocksave.set(cacheID, data);
                        object.endEffect(block, data.content, 'replace');
                    },
                    complete: function(){ block.find('.load-animation').css({'display': 'none'}); }
                });
            }
        };
        OptScript.resetQuickFilter = function (block, settings, filterVal) {
            var object = this; var blockid = block.attr('id');
            settings.page_current = 1;
            block.data('page_current', 1);
            if ('category' == settings.tabs_link) {
                if ('undefined' == typeof (object.$ajax[blockid + '_category'])) { object.$ajax[blockid + '_category'] = 0; }
                if (0 == filterVal) {
                    settings.category = object.$ajax[blockid + '_category'];
                    settings.categories = object.$ajax[blockid + '_categories'];
                    block.data('category', object.$ajax[blockid + '_category']);
                    block.data('categories', object.$ajax[blockid + '_categories']);
                } else {
                    settings.category = filterVal;
                    settings.categories = 0;
                    block.data('category', filterVal);
                    block.data('categories', 0);
                }
            }
            if ('tag' == settings.tabs_link) { settings.tags = filterVal; block.data('tags', filterVal); }
        };
        OptScript.blockLink = function (block, settings) {
            var object = this; var cacheSettings = settings;
            delete cacheSettings.page_max;
            var cacheID = JSON.stringify(cacheSettings);
            if (object.$blocksave.exist(cacheID)) {
                var data = object.$blocksave.get(cacheID);
                if ('undefined' != typeof data.page_max) { block.data('page_max', data.page_max); }
                object.endEffect(block, data.content, 'replace');
                return false;
            } else {
                $.ajax({
                    type: 'POST', url: vtParamsOpt.ajaxurl, data: { action: 'typecase_block_link', data: settings },
                    success: function (data) {
                        data = $.parseJSON(JSON.stringify(data));
                        if ('undefined' != typeof data.page_max) { block.data('page_max', data.page_max); }
                        object.$blocksave.set(cacheID, data);
                        object.endEffect(block, data.content, 'replace');
                    }
                });
            }
        };
        OptScript.startEffect = function (block, action) {
            var wrapper = block.find('.vt_wrap_eb'); var jcontain = wrapper.find('.vt_contain');
            block.find('.vt-block-link').addClass('vt_disable');
            jcontain.stop();
            if (action =='replace') {
                wrapper.css('height', wrapper.outerHeight());
                wrapper.prepend('<div class="vt-load-animation"></div>');
                jcontain.addClass('vt_overflow');
                jcontain.fadeTo('100', .3);
            } else {
                block.find('.vt-load-link').addClass('loading').animate({opacity: 0}, 100);
                block.find('.vt-load-animation').css({'display': 'block'}).delay(100).animate({opacity: 1}, 100);
            }
        };
        OptScript.navloadMore = function () {
            var object = this;
            $('.vt-load-link').off('click').on('click', function (e) {
                e.preventDefault(); e.stopPropagation();
                var link = $(this); var block = link.parents('.block-section'); var blockid = block.attr('id');
                if (true == object.$ajax[blockid + '_loading']) { return; }
                object.$ajax[blockid + '_loading'] = true;
                var settings = object.blockDatalist(block);
                if (settings.page_current >= settings.page_max) { return; }
                object.startEffect(block, 'append');
                object.navloadAction(block, settings);
            })
        };
        OptScript.navautoload = function () {
            var object = this; var infiniteElements = $('.vt_autoload');
            if (infiniteElements.length > 0) {
                infiniteElements.each(function () {
                    var link = $(this);
                    if (!link.hasClass('vt_hide_pagination')) {
                        var animation = link.find('.vt-load-animation'); var block = link.parents('.block-section'); var blockid = block.attr('id'); var svtoadID = 'infinite' + blockid; var settings = object.blockDatalist(block);
                        object.svtoad[svtoadID] = new Waypoint({
                            element: link,
                            handler: function (direction) {
                                if ('down' == direction) {
                                    if (true == object.$ajax[blockid + '_loading']) { return; }
                                    object.$ajax[blockid + '_loading'] = true;
                                    object.startEffect(block, 'append');
                                    OptScript.navloadAction(block, settings);
                                    setTimeout(function () { object.svtoad[svtoadID].destroy(); }, 10);
                                }
                            },
                            offset: '99%'
                        })
                    }
                });
            }
        };
        OptScript.navloadAction = function (block, settings) {
            settings.page_next = parseInt(settings.page_current) + 1;
            if (settings.page_next <= settings.page_max) {
                $.ajax({
                    type: 'POST', url: vtParamsOpt.ajaxurl, data: { action: 'typecase_loadnavs', data: settings },
                    success: function (data) {
                        data = $.parseJSON(JSON.stringify(data));
                        if ('undefined' != data.page_current) { block.data('page_current', data.page_current); }
                        if ('undefined' != data.notice) { data.content = data.content + data.notice; }
                        object.endEffect(block, data.content, 'append');
                    }
                });
            }
        };
        OptScript.vt_menu_cat = function() {
            var cat_haction; var cat_sub = $('.mega-category-menu .menu-item');
            cat_sub.hover(function(event) {
                event.stopPropagation();
                cat_sub = $(this);
                cat_sub.addClass('is-current-sub').siblings().removeClass('is-current-sub current-menu-item');
                var wrapper = cat_sub.parents('.mega-category-menu'); var block = wrapper.find('.block-section');
                cat_haction = setTimeout(function() { object.vt_menu_cat_load(cat_sub, block); }, 200);
            }, function() { clearTimeout(cat_haction); });
        };
        OptScript.vt_menu_cat_load = function(cat_sub, block) {
            var blockid = block.attr('id');
            if (true == object.$ajax[blockid + '_loading']) { return; }
            object.$ajax[blockid + '_loading'] = true;
            var settings = object.blockDatalist(block);
            settings.category = cat_sub.data('mega_sub_filter');
            settings.page_current = 1;
            settings.section_style = settings.section_style;
            settings.posts_per_page = settings.posts_per_page;
            block.data('category', settings.category);
            block.data('page_current', settings.page_current);
            object.startEffect(block, 'replace');
            setTimeout(function() { object.vt_menu_cat_fil(block, settings); }, 200);
        };
        OptScript.vt_menu_cat_fil = function(block, settings) {
            var vt_mcache = settings; delete vt_mcache.page_max; var cache_id = JSON.stringify(vt_mcache);
            if (object.$blocksave.exist(cache_id)) {
                var data = object.$blocksave.get(cache_id);
                if ('undefined' != data.page_max) { block.data('page_max', data.page_max); }
                object.endEffect(block, data.content, 'replace');
                return false;
            }
            $.ajax({
                type: 'POST', url: vtParamsOpt.ajaxurl, data: { action: 'typecase_menu_cat_opt', data: settings },
                success: function(data) {
                    data = $.parseJSON(data);
                    if ('undefined' != data.page_max) { block.data('page_max', data.page_max); }
                    object.$blocksave.set(cache_id, data);
                    object.endEffect(block, data.content, 'replace');
                }
            });
        };
        OptScript.endEffect = function (block, content, action) {
            var object = this;
            block.delay(100).queue(function () {
                var blockid = block.attr('id'); var wrapper = block.find('.vt_wrap_eb'); var jcontain = block.find('.vt_contain');
                block.find('.filter-link').removeClass('vt_removes'); block.find('.vt-block-link').removeClass('vt_disable'); jcontain.stop();
                if ('replace' == action) {
                    wrapper.find('.vt-load-animation').remove();
                    jcontain.html(content);
                    if (jcontain.hasClass('large-jcontain')) {
                        jcontain.imagesLoaded(function () {
                            setTimeout(function () { jcontain.removeClass('vt_overflow'); wrapper.css('height', 'auto'); setTimeout(function () { jcontain.fadeTo(200, 1); }, 200); }, 100)
                        });
                    } else {
                        jcontain.removeClass('vt_overflow'); wrapper.css('height', 'auto');
                        setTimeout(function () { jcontain.fadeTo(200, 1); }, 200);
                    }
                } else {
                    content = $(content); content.addClass('vt_hide'); content.addClass('show_block'); jcontain.append(content);
                    block.find('.vt-load-animation').animate({opacity: 0}, 200, function () { $(this).css({'display': 'none'}); });
                    setTimeout(function () { content.removeClass('vt_hide'); }, 200);
                    block.find('.vt-load-link').removeClass('loading').delay(200).animate({opacity: 1}, 200);
                }
                if (jcontain.hasClass('vt_ma_layout')) { $(jcontain).isotope('reloadItems').isotope({ sortBy: 'original-order', transitionDuration: 0 }); }
                $('.vt_pop_vid').magnificPopup({ type: 'iframe', mainClass: 'vt-fade-pop', removalDelay: 350, preloader: false, fixedContentPos: true, closeMarkup: '<button title="%title%" type="button" class="mfp-close">' + vtParamsOpt.pop_close_b + "</button>" });
                object.trackPagenav(block); block.dequeue();
                setTimeout(function () { object.$ajax[blockid + '_loading'] = false; object.loadpFunctions(); }, 50);
            });
        }
    };
    return OptScript;
}(cusMainScript || {}, jQuery));
( function( $ ) {
    var vt_wp_sl = function ($scope, $) {
                var swiperContainer = $scope.find('.vt-eb-sl').eq(0);
                if ( swiperContainer.length > 0 ) {
                    var dataOpt = swiperContainer.data('settings');
                    var navid = '.vtc-navigation-'+dataOpt.uniqid,
                        pagiid = '.vtc-pagination-'+dataOpt.uniqid;
                    var pagination =  {
                        el: pagiid+' .swiper-pagination',
                        type: 'bullets',
                        clickable: true,
                    };
                    var navigation = {
                        nextEl: navid+' .vt-swiper-button-next',
                        prevEl: navid+' .vt-swiper-button-prev',
                    };
                    var autoplay = {
                        delay: dataOpt.autoplay_delay,
                        disableOnInteraction: false,
                    };
                    if( dataOpt.autoplay == false ){
                        autoplay = false;
                    }
                    if( dataOpt.pagination == false ){
                        pagination = false;
                    }
                    if( dataOpt.navigation == false ){
                        navigation = false;
                    }
                    var desktop = parseInt( dataOpt.slideitem['desktop'] ) || 5,
                        tablet = parseInt( dataOpt.slideitem['tablet'] ) || 4,
                        landscape_mobile = parseInt( dataOpt.slideitem['landscape_mobile'] ) || 3,
                        large_mobile = parseInt( dataOpt.slideitem['large_mobile'] ) || 2,
                        small_mobile = parseInt( dataOpt.slideitem['small_mobile'] ) || 1;
                    var swiper = new Swiper( swiperContainer, {
                            loop: dataOpt.loop,
                            autoplay: autoplay,
                            watchSlidesVisibility: true,
                            parallax: dataOpt.parallax,
                            spaceBetween: dataOpt.spacebetween,
                            centeredSlides: dataOpt.centered,
                            speed: dataOpt.speed,
                            pagination: pagination,
                            navigation: navigation,
                            slidesPerView: desktop,
                            effect: dataOpt.effect,
                            breakpoints: {
                                320: {
                                    slidesPerView: small_mobile
                                },
                                480: {
                                    slidesPerView: large_mobile
                                },
                                576: {
                                    slidesPerView: landscape_mobile
                                },
                                768: {
                                    slidesPerView: tablet
                                },
                                992: {
                                    slidesPerView: desktop
                                },
                                1200: {
                                    slidesPerView: desktop
                                }
                            },
                        });
                }
      };

      var vt_wp_sl_tab = function ($scope, $) {
                var swipertabs = $scope.find('.vt-eb-sltab').eq(0);
                if ( swipertabs.length > 0 ) {
                   var swiper = new Swiper( swipertabs, {
                         loop: false,
                         slidesPerView: 4,
                         watchSlidesProgress: true,
                         direction: "vertical"
                  });
                }
                var swiperContainer = $scope.find('.vt-eb-sl').eq(0);
                if ( swiperContainer.length > 0 ) {
                    var dataOpt = swiperContainer.data('settings');
                    var navid = '.vtc-navigation-'+dataOpt.uniqid,
                        pagiid = '.vtc-pagination-'+dataOpt.uniqid;
                    var pagination =  {
                        el: pagiid+' .swiper-pagination',
                        type: 'bullets',
                        clickable: true,
                    };
                    var navigation = {
                        nextEl: navid+' .vt-swiper-button-next',
                        prevEl: navid+' .vt-swiper-button-prev',
                    };
                    var autoplay = {
                        delay: dataOpt.autoplay_delay,
                        disableOnInteraction: false,
                    };
                    if( dataOpt.autoplay == false ){
                        autoplay = false;
                    }
                    if( dataOpt.pagination == false ){
                        pagination = false;
                    }
                    if( dataOpt.navigation == false ){
                        navigation = false;
                    }
                    var swiper = new Swiper( swiperContainer, {
                            loop: dataOpt.loop,
                            autoplay: autoplay,
                            watchSlidesVisibility: true,
                            parallax: dataOpt.parallax,
                            spaceBetween: 0,
                            speed: dataOpt.speed,
                            pagination: pagination,
                            navigation: navigation,
                            slidesPerView: 1,
                            effect: dataOpt.effect,
                            thumbs: {
                              swiper: swiper,
                            },
                        });
                }
      };
      var vt_wp_showcase = function ( $scope, $ ) {
        var showcaseContainer = $scope.find('.vt-showcase-container').eq(0);
                if ( showcaseContainer.length > 0 ) {
                showcaseContainer.each(function () {
                    var $showContainer = $(this),
                        $bgsOpt = $showContainer.find('.vt-img-inner'),
                        $contentOpt = $showContainer.find('.vt-showcase-item-inner');
                        var $showContent = $showContainer.find('.vt-showcase-content');
                        var setActive = function () {
                            $bgsOpt.eq(0).addClass('vt-showcase-active');
                            $showContent.eq(0).addClass('vt-showcase-active');
                        }
                        $showContent.on('touchstart mouseenter', function (e) {
                            var $currentContent = $(this);
                            if ((!$currentContent.hasClass('vt-showcase-active'))) {
                                e.preventDefault();
                                $bgsOpt.removeClass('vt-showcase-active').eq($currentContent.index()).addClass('vt-showcase-active');
                                $showContent.removeClass('vt-showcase-active').eq($currentContent.index()).addClass('vt-showcase-active');
                            }
                        }).on('touchend mouseleave', function (e) {
                            var $currentContent = $(this);
                            if ((!$currentContent.hasClass('vt-showcase-active'))) {
                                $showContent.removeClass('vt-showcase-active').eq($currentContent.index()).addClass('vt-showcase-active');
                                $bgsOpt.removeClass('vt-showcase-active').eq($currentContent.index()).addClass('vt-showcase-active');
                            }
                        });
                });
            }
      };
      var visionMenu = function ( $scope, $ ) {
        var vtCusMenu = $scope.find('.menupost');
        if (vtCusMenu.length > 0) {
                vtCusMenu.each(function () {
                    var thisItem = $(this);
                    thisItem.find('.vt-cus-mega-menu').css({
                    'width': $(window).width(),
                    'left': -thisItem.offset().left,
                    });                    
                    thisItem.addClass('mega-menu-loaded')
                })
        }

        window.addEventListener('resize', function() {
            if (vtCusMenu.length > 0) {
                vtCusMenu.each(function () {
                    var thisItem = $(this);
                    thisItem.find('.vt-cus-mega-menu').css({
                    'width': $(window).width(),
                    'left': -thisItem.offset().left,
                    });                    
                    thisItem.addClass('mega-menu-loaded')
                })
        }   
        });
};

  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-feature-carousel.default', vt_wp_sl );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-newsticker-text.default', vt_wp_sl );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-feature-center-slider.default', vt_wp_sl );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-feature-slider.default', vt_wp_sl );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-feature-sl-tab.default', vt_wp_sl_tab );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-feature-hover.default', vt_wp_showcase );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/typecase-main-menu.default', visionMenu );
  });
})( jQuery );



